import mpi.*;
import java.nio.ByteBuffer ;
import java.io.* ; 

public class Latency {
  public Latency() {
  }
  public Latency(String[] args) throws Exception {  
    int WARM_UP = 15000 ;
    int REPEAT = 35000 ;
    long[] delays = new long[REPEAT];
     double latency = 0L;
    long start= 0L, stop=0L, init = 0L;
    MPI.Init(args);				
    int me = MPI.COMM_WORLD.Rank(); 
    System.out.println("Name ="+MPI.Get_processor_name());
    byte byteArray [] = null;
    int j=1, i=0;   	       		   	
    int LOG2N_MAX = 1000000,log2nbyte=0,padding=0;	
    long timed = 0L;		
    byteArray = new byte[2048];
    PrintStream out = null ;
    FileOutputStream fos = null ;

    
    for(i =0;i < byteArray.length;i++) {
      byteArray[i] = 's';
    }


    /* Logrithmic Loop */
    for (log2nbyte = 0; log2nbyte<= LOG2N_MAX && j<2048; ++log2nbyte) { 

        //MPI.COMM_WORLD.Barrier();

	j = (1 << log2nbyte);

        for(i=0;i < WARM_UP ;i++) {
          if(me == 0) {
            MPI.COMM_WORLD.Recv(byteArray,0,1,MPI.BYTE,1,998);
            MPI.COMM_WORLD.Send(byteArray,0,1,MPI.BYTE,1,998);
          }
          else if(me == 1) {
            MPI.COMM_WORLD.Send(byteArray,0,1,MPI.BYTE,0,998);
            MPI.COMM_WORLD.Recv(byteArray,0,1,MPI.BYTE,0,998);
          }
        }

        start = System.nanoTime();

	/* Latency Calculation Loop */
	for (i = 0; i < REPEAT ; i++) {	   			
	  if(me == 0) {
            MPI.COMM_WORLD.Send(byteArray,0,j,MPI.BYTE,1,998);	   		  	    MPI.COMM_WORLD.Recv(byteArray,0,j,MPI.BYTE,1,998);
	  } else if(me == 1) {
            MPI.COMM_WORLD.Recv(byteArray,0,j,MPI.BYTE,0,998);
            MPI.COMM_WORLD.Send(byteArray,0,j,MPI.BYTE,0,998);			
	  }
	}
      
        stop = System.nanoTime();


	latency = (((stop-start)/(REPEAT*2))/1000.0);

	if(me == 0) { 
          System.out.println(j+"\t"+(latency)+
		               "\t"+
            (( 8*j ) /( 1024*1024* (latency/(1000.0*1000)))) );
	}

        MPI.COMM_WORLD.Barrier() ;   
    }//end logrithmic loop

    MPI.Finalize();	  	
  }//end args constructor.

  public static void main(String[] args) throws Exception { 
 
     new Latency(args) ; 
  } 
 
}//end class.
